#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:1
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=9
#SBATCH --job-name=LP_remainder
#SBATCH --time=30:00:00
#SBATCH --mem=90G
#SBATCH --exclude=gnodee8,gnodec1,gnodee6

PYTHON='/scratch/shared/beegfs/yuki/envs/py37/bin/python3'
#TMPDIR='/scratch/local/ssd/yuki'
DEV=0


rsync -r /scratch/shared/beegfs/yuki/data/cifar-100-python ${TMPDIR}
DATASET_PATH=${TMPDIR}/cifar-100-python
EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}/LP-CIF100"
mkdir -p $EXPERIMENT_PATH

CUDA_VISIBLE_DEVICES=$DEV ${PYTHON} main_lincls.py \
            -a resnet50 \
            --dataset 'cifar100' \
            --lr 30.0 \
            --batch-size 256 \
            --pretrained ${MODEL_STR} \
            --dump_path ${EXPERIMENT_PATH} \
            ${DATASET_PATH} 2>&1 | tee -a ${EXPERIMENT_PATH}/log.txt


#####################################

tar xf /scratch/shared/beegfs/yuki/data/102flowers.tar -C ${TMPDIR}

DATASET_PATH=${TMPDIR}/102flowers
EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}/LP-flowers102"
mkdir -p $EXPERIMENT_PATH


CUDA_VISIBLE_DEVICES=$DEV ${PYTHON} main_lincls.py \
            -a resnet50 \
            --dataset 'flowers102' \
            --lr 30.0 \
            --batch-size 256 \
            --pretrained ${MODEL_STR} \
            --dump_path ${EXPERIMENT_PATH} \
            ${DATASET_PATH} 2>&1 | tee -a ${EXPERIMENT_PATH}/log.txt &


###########

DATASET_PATH=/scratch/shared/beegfs/yuki/data/herbarium2019
EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}/LP-herba19"
mkdir -p $EXPERIMENT_PATH

CUDA_VISIBLE_DEVICES=$DEV ${PYTHON} main_lincls.py \
            -a resnet50 \
            --dataset 'herba19' \
            --lr 30.0 \
            --batch-size 256 \
            --pretrained ${MODEL_STR} \
            --dump_path ${EXPERIMENT_PATH} \
            ${DATASET_PATH} 2>&1 | tee -a ${EXPERIMENT_PATH}/log.txt
